/*
 * Decompiled with CFR 0.152.
 */
package emulator.shell.GUI.debugger;

import emulator.EmulatorException;
import emulator.hardware.HwWord;
import emulator.hardware.nmos6502.Flags6502;
import emulator.hardware.nmos6502.stack.CpuStack;
import emulator.hardware.nmos6502.stack.StackEntry;
import emulator.shell.GUI.debugger.CodePanel;
import emulator.shell.GUI.debugger.ScrollView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.UIManager;

public class StackPanel
extends ScrollView {
    private CpuStack stack = null;
    private boolean is_running;
    private int visible_lines = 1;
    private int current_position = 0;
    private int current_range = 1;
    private StackEntry[] stack_contents = null;
    private int selected_line = -1;
    CodePanel code_panel = null;

    public StackPanel(CpuStack stack, CodePanel code_panel) {
        this.stack = stack;
        this.code_panel = code_panel;
        this.is_running = true;
        this.initPanel();
    }

    private void initPanel() {
        this.setLayout(new BorderLayout());
        this.initScrollBar();
        this.scroll_pane = new StackPane();
        this.add((Component)this.scroll_pane, "Center");
        this.scroll_pane.addKeyListener(new ScrollView.KeyboardListener(this));
        this.addMouseWheelListener(new ScrollView.MouseScrollListener(this));
        this.addKeyListener(new ScrollView.KeyboardListener(this));
    }

    public void updateRunState(boolean run_state) {
        this.is_running = run_state;
        if (!this.is_running) {
            try {
                this.stack_contents = this.stack.getContents();
            }
            catch (EmulatorException e) {
                this.stack_contents = new StackEntry[0];
            }
            this.setCurrentRange(this.stack_contents.length);
            this.setCurrentPosition(0);
            this.selectLine(-1);
        }
        this.showScrollBar(this.isPanelActive());
        this.repaint();
    }

    @Override
    boolean isPanelActive() {
        return !this.is_running;
    }

    @Override
    void setCurrentPosition(int desired_position) {
        this.current_position = Math.max(0, Math.min(desired_position, this.getCurrentRange() - this.getVisibleLines()));
    }

    @Override
    int getCurrentPosition() {
        return this.current_position;
    }

    @Override
    void setCurrentRange(int current_range) {
        this.current_range = current_range;
    }

    @Override
    int getCurrentRange() {
        return this.current_range;
    }

    @Override
    void setVisibleLines(int i) {
        this.visible_lines = i;
    }

    @Override
    int getVisibleLines() {
        return this.visible_lines;
    }

    public void selectLine(int line) {
        this.selected_line = line < this.getCurrentRange() ? line : -1;
    }

    public void jumpToCode(int hitTest) {
        StackEntry entry;
        int source;
        if (this.selected_line >= 0 && this.selected_line < this.stack_contents.length && (source = this.getSourceLocation(entry = this.stack_contents[this.selected_line])) >= 0) {
            this.showCode(source);
        }
    }

    private int getSourceLocation(StackEntry entry) {
        int source = -1;
        switch (entry.getSource()) {
            case 2: 
            case 3: {
                source = (int)entry.getData().getNumber() - 2;
                break;
            }
            case 1: {
                source = (int)entry.getData().getNumber();
            }
        }
        return source;
    }

    private void showCode(int address) {
        if (this.code_panel != null) {
            this.code_panel.showCode(address, true);
        }
    }

    public class StackPane
    extends ScrollView.ScrollPane {
        public StackPane() {
            super(StackPanel.this);
            this.addMouseListener(new MouseEventHandler());
        }

        @Override
        public void paint(Graphics g) {
            Dimension d = this.getMinimumSize();
            g.setColor(UIManager.getColor("ScrollPane.background"));
            g.fillRect(0, 0, d.width, d.height);
            g.setFont(StackPanel.this.getTextFont());
            if (StackPanel.this.isPanelActive()) {
                int i = 0;
                while (i < StackPanel.this.getVisibleLines()) {
                    int index = StackPanel.this.getCurrentPosition() + i;
                    g.setColor(UIManager.getColor("ScrollPane.background"));
                    g.fillRect(StackPanel.this.getBorderSize(), StackPanel.this.getBorderSize() + i * StackPanel.this.getLineMetrics().getLineHeight() + 1, StackPanel.this.getLineMetrics().getLineWidth(), StackPanel.this.getLineMetrics().getLineHeight() - 1);
                    g.setColor(Color.black);
                    if (index == StackPanel.this.selected_line) {
                        g.setColor(Color.blue);
                        g.fillRect(StackPanel.this.getBorderSize(), StackPanel.this.getBorderSize() + i * StackPanel.this.getLineMetrics().getLineHeight() + 1, StackPanel.this.getLineMetrics().getLineWidth() - 1, StackPanel.this.getLineMetrics().getLineHeight() - 1);
                        g.setColor(Color.white);
                    }
                    if (index >= 0 && index < StackPanel.this.stack_contents.length) {
                        StackEntry entry = StackPanel.this.stack_contents[index];
                        int x = 0;
                        String s = "00" + Integer.toHexString(entry.getSp()).toUpperCase();
                        s = "[$" + s.substring(s.length() - 2) + "]";
                        this.printString(g, s, x, i);
                        this.printString(g, entry.getData().toString(), x += 6, i);
                        x += 7;
                        switch (entry.getSource()) {
                            case 2: {
                                this.printString(g, "[BRK]", x, i);
                                break;
                            }
                            case 1: {
                                this.printString(g, "[INT]", x, i);
                                break;
                            }
                            case 3: {
                                this.printString(g, "[JSR]", x, i);
                                break;
                            }
                            default: {
                                if (!(entry.getData() instanceof Flags6502)) break;
                                this.printString(g, "\"" + ((Flags6502)entry.getData()).toFlagString() + "\"", x, i);
                            }
                        }
                        x += 12;
                        int source = StackPanel.this.getSourceLocation(entry);
                        if (source >= 0) {
                            this.printString(g, "*=$" + new HwWord((long)source).toString(), x, i);
                        }
                        x += 10;
                        if (source >= 0) {
                            this.printString(g, StackPanel.this.code_panel.getLabel(source), x, i);
                        }
                    }
                    ++i;
                }
            } else {
                g.setColor(Color.darkGray);
                this.printString(g, "[Stack unavailable while CPU is running]", 0, 0);
            }
        }

        class MouseEventHandler
        extends MouseAdapter {
            MouseEventHandler() {
            }

            private void handleSelect(Point point) {
                StackPane.this.requestFocusInWindow();
                StackPanel.this.selectLine(StackPane.this.hitTest(point));
                StackPane.this.repaint();
            }

            private void handleDoubleClick(Point point) {
                StackPanel.this.jumpToCode(StackPane.this.hitTest(point));
                StackPane.this.repaint();
            }

            @Override
            public void mouseClicked(MouseEvent event) {
                this.handleSelect(event.getPoint());
                if (event.getClickCount() == 2) {
                    this.handleDoubleClick(event.getPoint());
                }
            }
        }
    }
}

